USE Acuity4_Public_Content
GO

-- Add new Question Setting to Lookup table new look and feel 
DELETE FROM [SAT].[QuestionTypeSettingDefinitions] Where QuestionTypeId=28 and QuestionSettingDefinitionId in (SELECT Id FROM [SAT].[QuestionSettingDefinitions] WHERE NAME IN ('Unselected','Selected','All', 'AddChoiceButtonLabel'))
DELETE FROM [SAT].[LocalizableTexts_TranslatableQuestionSetting]  Where QuestionSettingDefinitionId in (SELECT Id FROM [SAT].[QuestionSettingDefinitions] WHERE NAME IN ('Unselected','Selected','All', 'AddChoiceButtonLabel'))
DELETE FROM [SAT].[QuestionSettingDefinitions] WHERE Name in ('Unselected','Selected','All', 'AddChoiceButtonLabel') 

EXEC [SAT].VX_sp_CreateQuestionTypeSetting 'LookupTable', 'AllowRespondentToAddCustomChoice', 'Boolean'

-- 0 Not Allowed, 1 Private, 2 Public - enum LookupTableInputAccessEnum
EXEC [SAT].VX_sp_CreateQuestionTypeSetting 'LookupTable', 'AnonymousRespondentInput', 'Numeric', 0, 0
EXEC [SAT].VX_sp_CreateQuestionTypeSetting 'LookupTable', 'LoggedInRespondentInput', 'Numeric', 1, 0
EXEC [SAT].VX_sp_CreateQuestionTypeSetting 'LookupTable', 'PhoneAgentInput', 'Numeric', 2, 0

IF EXISTS(SELECT 1 FROM [SAT].[QuestionTypes] WHERE Id = 28)
BEGIN
    EXEC [SAT].VX_sp_CreateQuestionTypeSetting 'LookupTable', 'LookupTableAll', 'Text', 'All', 1
    EXEC [SAT].VX_sp_CreateQuestionTypeSetting 'LookupTable', 'LookupTableSelected', 'Text', 'Selected', 1
    EXEC [SAT].VX_sp_CreateQuestionTypeSetting 'LookupTable', 'LookupTableUnselected', 'Text', 'Unselected', 1
    EXEC [SAT].VX_sp_CreateQuestionTypeSetting 'LookupTable', 'LookupTableAddChoiceButtonLabel', 'Text', 'Add Choice', 1
END

DECLARE @settingDefinitionResponseLookupTableAll INT
DECLARE @settingDefinitionResponseLookupTableSelected INT
DECLARE @settingDefinitionResponseLookupTableUnselected INT
DECLARE @settingDefinitionResponseLookupTableAddChoiceButtonLabel INT

DELETE FROM [SAT].[LocalizableTexts] WHERE Id >= 1117262 AND Id <= 1117270

SELECT Id FROM [SAT].[QuestionSettingDefinitions] WHERE Name in ('LookupTableAll', 'LookupTableSelected', 'LookupTableUnselected', 'LookupTableAddChoiceButtonLabel')

SELECT @settingDefinitionResponseLookupTableAll = Id FROM [SAT].[QuestionSettingDefinitions] WHERE Name = 'LookupTableAll'
SELECT @settingDefinitionResponseLookupTableSelected = Id FROM [SAT].[QuestionSettingDefinitions] WHERE Name = 'LookupTableSelected'
SELECT @settingDefinitionResponseLookupTableUnselected = Id FROM [SAT].[QuestionSettingDefinitions] WHERE Name = 'LookupTableUnselected'
SELECT @settingDefinitionResponseLookupTableAddChoiceButtonLabel = Id FROM [SAT].[QuestionSettingDefinitions] WHERE Name = 'LookupTableAddChoiceButtonLabel'

SET IDENTITY_INSERT [SAT].[LocalizableTexts] ON 
INSERT [SAT].[LocalizableTexts] ([Id], [Version], [Language], [Text]) VALUES (1117263, 0, N'en', N'All')
INSERT [SAT].[LocalizableTexts] ([Id], [Version], [Language], [Text]) VALUES (1117264, 0, N'fr', N'Tous')
INSERT [SAT].[LocalizableTexts] ([Id], [Version], [Language], [Text]) VALUES (1117265, 0, N'en', N'Selected')
INSERT [SAT].[LocalizableTexts] ([Id], [Version], [Language], [Text]) VALUES (1117266, 0, N'fr', N'Slectionn(s)')
INSERT [SAT].[LocalizableTexts] ([Id], [Version], [Language], [Text]) VALUES (1117267, 0, N'en', N'Unselected')
INSERT [SAT].[LocalizableTexts] ([Id], [Version], [Language], [Text]) VALUES (1117268, 0, N'fr', N'Non slectionn(s)')
INSERT [SAT].[LocalizableTexts] ([Id], [Version], [Language], [Text]) VALUES (1117269, 0, N'en', N'Add Choice')
INSERT [SAT].[LocalizableTexts] ([Id], [Version], [Language], [Text]) VALUES (1117270, 0, N'fr', N'Ajouter un choix')
SET IDENTITY_INSERT [SAT].[LocalizableTexts] OFF

INSERT [SAT].[LocalizableTexts_TranslatableQuestionSetting] ([QuestionId],[QuestionSettingDefinitionId],[Id],[Version],[SkipLogic_Id],[SkipLogic_Version]) VALUES (933, @settingDefinitionResponseLookupTableAll , 1117263, 0, NULL, NULL)
INSERT [SAT].[LocalizableTexts_TranslatableQuestionSetting] ([QuestionId],[QuestionSettingDefinitionId],[Id],[Version],[SkipLogic_Id],[SkipLogic_Version]) VALUES (933, @settingDefinitionResponseLookupTableAll , 1117264, 0, NULL, NULL)

INSERT [SAT].[LocalizableTexts_TranslatableQuestionSetting] ([QuestionId],[QuestionSettingDefinitionId],[Id],[Version],[SkipLogic_Id],[SkipLogic_Version]) VALUES (933, @settingDefinitionResponseLookupTableSelected, 1117265, 0, NULL, NULL)
INSERT [SAT].[LocalizableTexts_TranslatableQuestionSetting] ([QuestionId],[QuestionSettingDefinitionId],[Id],[Version],[SkipLogic_Id],[SkipLogic_Version]) VALUES (933, @settingDefinitionResponseLookupTableSelected, 1117266, 0, NULL, NULL)

INSERT [SAT].[LocalizableTexts_TranslatableQuestionSetting] ([QuestionId],[QuestionSettingDefinitionId],[Id],[Version],[SkipLogic_Id],[SkipLogic_Version]) VALUES (933, @settingDefinitionResponseLookupTableUnselected, 1117267, 0, NULL, NULL)
INSERT [SAT].[LocalizableTexts_TranslatableQuestionSetting] ([QuestionId],[QuestionSettingDefinitionId],[Id],[Version],[SkipLogic_Id],[SkipLogic_Version]) VALUES (933, @settingDefinitionResponseLookupTableUnselected, 1117268, 0, NULL, NULL)

INSERT [SAT].[LocalizableTexts_TranslatableQuestionSetting] ([QuestionId],[QuestionSettingDefinitionId],[Id],[Version],[SkipLogic_Id],[SkipLogic_Version]) VALUES (933, @settingDefinitionResponseLookupTableAddChoiceButtonLabel, 1117269, 0, NULL, NULL)
INSERT [SAT].[LocalizableTexts_TranslatableQuestionSetting] ([QuestionId],[QuestionSettingDefinitionId],[Id],[Version],[SkipLogic_Id],[SkipLogic_Version]) VALUES (933, @settingDefinitionResponseLookupTableAddChoiceButtonLabel, 1117270, 0, NULL, NULL)

-- Add new Question Setting to Lookup table new look and feel 
IF EXISTS(SELECT 1 FROM [SAT].[QuestionTypes] WHERE Id = 28)
BEGIN
    EXEC [SAT].VX_sp_CreateQuestionTypeSetting 'LookupTable', 'AddChoicePopupTitle', 'Text', 'Add a choice', 1
    EXEC [SAT].VX_sp_CreateQuestionTypeSetting 'LookupTable', 'ConfirmationButtonLabel', 'Text', 'Confirm', 1
    EXEC [SAT].VX_sp_CreateQuestionTypeSetting 'LookupTable', 'CancelButtonLabel', 'Text', 'Cancel', 1
END

DECLARE @settingDefinitionResponseLookupTableAddChoicePopupTitle INT
DECLARE @settingDefinitionResponseLookupTableConfirmationButtonLabel INT
DECLARE @settingDefinitionResponseLookupTableCancelButtonLabel INT

DELETE FROM [SAT].[LocalizableTexts] WHERE Id >= 1117271 AND Id <= 1117276

SELECT @settingDefinitionResponseLookupTableAddChoicePopupTitle = Id FROM [SAT].[QuestionSettingDefinitions] WHERE Name = 'AddChoicePopupTitle'
SELECT @settingDefinitionResponseLookupTableConfirmationButtonLabel = Id FROM [SAT].[QuestionSettingDefinitions] WHERE Name = 'ConfirmationButtonLabel'
SELECT @settingDefinitionResponseLookupTableCancelButtonLabel = Id FROM [SAT].[QuestionSettingDefinitions] WHERE Name = 'CancelButtonLabel'

SET IDENTITY_INSERT [SAT].[LocalizableTexts] ON 
INSERT [SAT].[LocalizableTexts] ([Id], [Version], [Language], [Text]) VALUES (1117271, 0, N'en', N'Add a choice')
INSERT [SAT].[LocalizableTexts] ([Id], [Version], [Language], [Text]) VALUES (1117272, 0, N'fr', N'Ajouter un choix')
INSERT [SAT].[LocalizableTexts] ([Id], [Version], [Language], [Text]) VALUES (1117273, 0, N'en', N'Confirm')
INSERT [SAT].[LocalizableTexts] ([Id], [Version], [Language], [Text]) VALUES (1117274, 0, N'fr', N'Confirmer')
INSERT [SAT].[LocalizableTexts] ([Id], [Version], [Language], [Text]) VALUES (1117275, 0, N'en', N'Cancel')
INSERT [SAT].[LocalizableTexts] ([Id], [Version], [Language], [Text]) VALUES (1117276, 0, N'fr', N'Annuler')
SET IDENTITY_INSERT [SAT].[LocalizableTexts] OFF

INSERT [SAT].[LocalizableTexts_TranslatableQuestionSetting] ([QuestionId],[QuestionSettingDefinitionId],[Id],[Version],[SkipLogic_Id],[SkipLogic_Version]) VALUES (933, @settingDefinitionResponseLookupTableAddChoicePopupTitle , 1117271, 0, NULL, NULL)
INSERT [SAT].[LocalizableTexts_TranslatableQuestionSetting] ([QuestionId],[QuestionSettingDefinitionId],[Id],[Version],[SkipLogic_Id],[SkipLogic_Version]) VALUES (933, @settingDefinitionResponseLookupTableAddChoicePopupTitle , 1117272, 0, NULL, NULL)

INSERT [SAT].[LocalizableTexts_TranslatableQuestionSetting] ([QuestionId],[QuestionSettingDefinitionId],[Id],[Version],[SkipLogic_Id],[SkipLogic_Version]) VALUES (933, @settingDefinitionResponseLookupTableConfirmationButtonLabel, 1117273, 0, NULL, NULL)
INSERT [SAT].[LocalizableTexts_TranslatableQuestionSetting] ([QuestionId],[QuestionSettingDefinitionId],[Id],[Version],[SkipLogic_Id],[SkipLogic_Version]) VALUES (933, @settingDefinitionResponseLookupTableConfirmationButtonLabel, 1117274, 0, NULL, NULL)

INSERT [SAT].[LocalizableTexts_TranslatableQuestionSetting] ([QuestionId],[QuestionSettingDefinitionId],[Id],[Version],[SkipLogic_Id],[SkipLogic_Version]) VALUES (933, @settingDefinitionResponseLookupTableCancelButtonLabel, 1117275, 0, NULL, NULL)
INSERT [SAT].[LocalizableTexts_TranslatableQuestionSetting] ([QuestionId],[QuestionSettingDefinitionId],[Id],[Version],[SkipLogic_Id],[SkipLogic_Version]) VALUES (933, @settingDefinitionResponseLookupTableCancelButtonLabel, 1117276, 0, NULL, NULL)



